<?php

    declare(strict_types = 1);
    header("Content-Type: application/json");

    require __DIR__ . '/../../vendor/autoload.php';

    use Asn\Core\Dice;
    use Asn\Core\Http\Request;
    use Asn\App\Model\Location;

$dc = new Dice();
    $dc->addRules([
        '*' => ['shared' => true]
    ]);

    $request = new Request();
    $jsonData = $request->getInputStream();
    $inputArr = json_decode($jsonData, true);

    if (!isset($inputArr['areaId']) || !is_numeric($inputArr['areaId'])) {
        exit(json_encode(['success' => false, 'msg' => 'Invalid data!']));
    }

    $areaId = (int) $inputArr['areaId'];

    // fetch districts
    try {
        $dcLocation = $dc->create(Location::class);
        $districts = $dcLocation->getDistricts($areaId);
        $districtsOptions = [];

        foreach ($districts as $key => $value) {
            $districtsOptions[] = ['val' => $value['l2_no'], 'txt' => $value['l2_name']];
        }
        exit(json_encode(['success' => true, 'msg' => '', 'districtsOptions' => $districtsOptions]));
    } catch (\Throwable $thr) {
        exit(json_encode(['success' => false, 'msg' => $thr->getMessage()]));
    }
