<?php

    declare(strict_types = 1);
    require __DIR__ . '/../../vendor/autoload.php';

    set_time_limit(3600);

    use Asn\Core\Dice;
    use Asn\App\Model\AgencyPilot\FetchArea;
    use Asn\App\Model\AgencyPilot\FetchAuction;
    use Asn\App\Model\AgencyPilot\FetchDimensions;
    use Asn\App\Model\AgencyPilot\FetchFloors;
    use Asn\App\Model\AgencyPilot\FetchLocation;
    use Asn\App\Model\AgencyPilot\FetchLocationGroups;
    use Asn\App\Model\AgencyPilot\FetchMarketStatus;
    use Asn\App\Model\AgencyPilot\FetchTenureTerms;
    use Asn\App\Model\AgencyPilot\FetchUnitTypeGroups;
    use Asn\App\Model\AgencyPilot\FetchUnitTypes;
    use Asn\App\Model\AgencyPilot\FetchProperties;

$dc = new Dice();
    $dc->addRules([
        '*' => ['shared' => true]
    ]);

    // Areas
    try {
        $dcFetch = $dc->create(FetchArea::class);
        $dcFetch->insertData();
        echo "Areas updated" . "\n\r";
    } catch (\Throwable $thr) {
        echo $thr->getMessage();
    }

    // Auction
    try {
        $dcFetch = $dc->create(FetchAuction::class);
        $dcFetch->insertData();
        echo "Auctions updated" . "\n\r";
    } catch (\Throwable $thr) {
        echo $thr->getMessage();
    }

    // Dimesions
    try {
        $dcFetch = $dc->create(FetchDimensions::class);
        $dcFetch->insertData();
        echo "Dimesions updated" . "\n\r";
    } catch (\Throwable $thr) {
        echo $thr->getMessage();
    }

    // Floors
    try {
        $dcFetch = $dc->create(FetchFloors::class);
        $dcFetch->insertData();
        echo "Floors updated" . "\n\r";
    } catch (\Throwable $thr) {
        echo $thr->getMessage();
    }

    // Locations
    try {
        $dcFetch = $dc->create(FetchLocation::class);
        $dcFetch->insertData();
        echo "Locations updated" . "\n\r";
    } catch (\Throwable $thr) {
        echo $thr->getMessage();
    }

    // Location Groups
    try {
        $dcFetch = $dc->create(FetchLocationGroups::class);
        $dcFetch->insertData();
        echo "Location Groups updated" . "\n\r";
    } catch (\Throwable $thr) {
        echo $thr->getMessage();
    }

    // Market status
    try {
        $dcFetch = $dc->create(FetchMarketStatus::class);
        $dcFetch->insertData();
        echo "Market status updated" . "\n\r";
    } catch (\Throwable $thr) {
        echo $thr->getMessage();
    }

    // Tenure terms
    try {
        $dcFetch = $dc->create(FetchTenureTerms::class);
        $dcFetch->insertData();
        echo "Tenure terms updated" . "\n\r";
    } catch (\Throwable $thr) {
        echo $thr->getMessage();
    }

    // Unit type groups
    try {
        $dcFetch = $dc->create(FetchUnitTypeGroups::class);
        $dcFetch->insertData();
        echo "Unit type groups updated" . "\n\r";
    } catch (\Throwable $thr) {
        echo $thr->getMessage();
    }

    // Unit types
    try {
        $dcFetch = $dc->create(FetchUnitTypes::class);
        $dcFetch->insertData();
        echo "Unit types updated" . "\n\r";
    } catch (\Throwable $thr) {
        echo $thr->getMessage();
    }

    // Properties
    try {
        $dcFetch = $dc->create(FetchProperties::class);
        $dcFetch->setUrlParams('fr', 'true')
                ->setUrlParams('full', 'true');

        $dcFetch->insertData();
        echo "Properties updated";
    } catch (\Throwable $thr) {
        echo $thr->getMessage();
    }
