<?php

    declare(strict_types = 1);
    require __DIR__ . '/../../vendor/autoload.php';

    set_time_limit(3600);

    use Asn\Core\Dice;
    use Asn\App\Model\AgencyPilot\FetchProperties;

    $dc = new Dice();
    $dc->addRules([
        '*' => ['shared' => true]
    ]);

    $fd = $dc->create(FetchProperties::class);
    $fd->setUrlParams('fr', 'true')
        ->setUrlParams('full', 'true');
    try {
        $fd->insertData();
        echo "Properties updated successfully";
    } catch (\Throwable $thr) {
        echo $thr->getMessage();
    }
