var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
  return typeof obj;
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
};

var asyncToGenerator = function (fn) {
  return function () {
    var gen = fn.apply(this, arguments);
    return new Promise(function (resolve, reject) {
      function step(key, arg) {
        try {
          var info = gen[key](arg);
          var value = info.value;
        } catch (error) {
          reject(error);
          return;
        }

        if (info.done) {
          resolve(value);
        } else {
          return Promise.resolve(value).then(function (value) {
            step("next", value);
          }, function (err) {
            step("throw", err);
          });
        }
      }

      return step("next");
    });
  };
};

// Global variables
var xhrPool = []; // AJAX requests pool

/**
 * Makes an ajax call
 *
 * @param {object} settings
 * @param {string} settings.URL
 * @param {?boolean} settings.addToPool
 * @param {?boolean} settings.abortPending
 * @param {string} settings.reqMethod [POST|GET]
 * @param {string} settings.reqType [formdata|json]
 * @param {object} settings.reqParams [null]
 * @param {string} settings.respType [json|text]
 * @param {object} settings.callback 
 */

function ajax(settings) {

    if (settings.abortPending === true) {
        for (var i = 0, len = xhrPool.length; i < len; i++) {
            if (xhrPool[i]) {
                xhrPool[i].abort();
            }
        }
        xhrPool.length = 0;
    }

    return new Promise(function (resolve, reject) {
        var xhr = new XMLHttpRequest(),
            strURL = settings.URL,
            reqMethod = settings.reqMethod || 'POST',
            reqType = settings.reqType || 'formdata',
            respType = settings.respType || 'json',
            reqParams = _typeof(settings.reqParams) === 'object' ? settings.reqParams : null;

        if (reqParams) {
            if (reqMethod === 'GET') {
                var qs = '',
                    rqKeys = Object.keys(reqParams);
                for (var _i = 0, iLen = rqKeys.length; _i < iLen; _i++) {
                    qs += encodeURIComponent(rqKeys[_i]) + "=" + encodeURIComponent(reqParams[rqKeys[_i]]) + "&";
                }

                if (qs) {
                    strURL += "?" + qs.slice(0, -1);
                }
            } else if (reqType === 'json') {
                reqParams = JSON.stringify(reqParams);
            }
        }

        xhr.onreadystatechange = function () {
            if (xhr.readyState === 1 && settings.addToPool) {
                xhrPool.push(xhr);
            }

            if (xhr.readyState === 4) {
                if (settings.addToPool) {
                    var hxrIndex = xhrPool.indexOf(xhr);
                    if (hxrIndex > -1) {
                        xhrPool.splice(hxrIndex, 1);
                    }
                }

                if (xhr.status === 200) {
                    var resp = xhr.response;
                    if (respType === 'json') {
                        // Needed for IE only as it return sring instead of JSON
                        resp = xhr.responseType === 'json' ? xhr.response : JSON.parse(xhr.responseText);
                        if ((typeof resp === 'undefined' ? 'undefined' : _typeof(resp)) !== 'object' || resp === null) {
                            reject(resp);
                        }
                    }
                    resolve(resp);
                } else {
                    reject(xhr.status);
                }
            }
        };

        xhr.open(reqMethod, strURL, true);

        if (reqType === 'json') {
            xhr.setRequestHeader("Content-Type", "application/json");
        }
        xhr.responseType = respType;
        xhr.send(reqParams);
    });
}

/**
 * Check if elem is an HTML element
 * @param {object} elem
 * @return {Boolean}
 */
function isHtmlElement(elem) {
    return elem && (typeof elem === 'undefined' ? 'undefined' : _typeof(elem)) === 'object' && elem.nodeType === 1;
}

/**
 * Returns HTML element from ID or node element.
 * Undefined if the element does not exist
 *
 * @param {string|object} elemRef
 * @return {object|undefined}
 */
function getHtmlElement(elemRef) {
    var elem = void 0;
    if (typeof elemRef === 'string') {
        elem = document.getElementById(elemRef);
    } else if (elemRef && (typeof elemRef === 'undefined' ? 'undefined' : _typeof(elemRef)) === 'object' && elemRef.nodeType === 1) {
        elem = elemRef;
    }
    return elem;
}

/**
 * Check if a string is numeric
 *
 * @param {string} val
 * @return {Boolean}
 */
function isNumeric(val) {
    return !isNaN(parseFloat(val)) && isFinite(val);
}

/**
 * Check if a string is "empty"
 *
 * @param {string} val
 * @return {Boolean}
 */
function isEmpty(val) {
    return !val || typeof val === 'string' && val.trim() === '';
}

/**
 * Returns the first parent element of the specified class or node name
 *
 * @param {object} elem
 * @param {string} name class name or node(tag) name
 * @return {object|undefined}
 */
function getParentElement(elem, name) {
    if (!isHtmlElement(elem) || isEmpty(name)) {
        return;
    }

    if (name.slice(0, 1) === '.') {
        // Class name
        name = name.slice(1);
        while (elem.parentNode) {
            elem = elem.parentNode;
            try {
                if (elem.classList.contains(name)) {
                    return elem;
                }
            } catch (err) {
                return;
            }
        }
    } else {
        // Tag name
        name = name.toUpperCase();
        while (elem.parentNode) {
            elem = elem.parentNode;
            if (elem.nodeName === name) {
                return elem;
            }
        }
    }
}

/**
 *
 * Append options to select element
 *
 * @param {object|string} elemRef HTML element or id
 * @param {array} opts
 */
function selectAppendOptions(elemRef, opts) {
    var elem = getHtmlElement(elemRef);

    if (elem && Array.isArray(opts)) {
        var doc = document,
            frag = doc.createDocumentFragment();

        var opt = void 0,
            optAttr = void 0;

        for (var i = 0, iLen = opts.length; i < iLen; i++) {
            opt = doc.createElement('option');
            if (opts[i].attr) {
                optAttr = opts[i].attr;
                opt.setAttribute(optAttr, optAttr);
            }
            opt.value = opts[i].val;
            opt.text = opts[i].txt;
            frag.appendChild(opt);
        }
        elem.appendChild(frag);
    }
}

/**
 * Remove options from select element, but keep first k options
 *
 * @param {object} elemRef HTML element or id
 * @param {int} k number of options to keep
 */
function selectRemoveOptions(elemRef, k) {
    var elem = getHtmlElement(elemRef);
    if (elem) {
        var keep = isNumeric(k) && k >= 0 ? k : 0,
            i = elem.options.length;
        while (i-- > keep) {
            elem.remove(i);
        }
    }
}

/**
 *
 * @param {type} propertyType
 * @param {type} filterId - the form id
 * @param {type} page - page number
 * @param {type} perPage - records per page
 * @returns {Promise}
 */
function propertyFinder(propertyType, filterId, page, perPage) {

    var doc = document;
    var form = doc.getElementById(filterId),
        searchResContainer = doc.getElementById('search-results'),
        oFD = form ? new FormData(form) : new FormData();

    oFD.append("propertyType", propertyType);
    oFD.append("filterId", filterId);
    oFD.append("page", page);
    oFD.append("perPage", perPage);

    return ajax({
        "URL": "/ajax/find-properties.php",
        "reqParams": oFD
    }).then(function (resp) {

        if (resp.success === true) {

            searchResContainer.innerHTML = resp.result;
        } else {
            searchResContainer.textContent = '';
        }

        var msgE = doc.getElementById('msg');
        if (msgE && resp.msg) {
            msgE.textContent = resp.msg;
        }
    });
}

function searchOffice() {
    var doc = document,
        areasE = doc.getElementById('area'),
        districtsE = doc.getElementById('district'),
        msgE = doc.getElementById('msg');

    // get district by selected area
    areasE.addEventListener("change", function (e) {
        selectRemoveOptions(districtsE, 2);
        ajax({
            "URL": "/ajax/location/get-districts.php",
            "reqMethod": "POST",
            "reqType": "json",
            "reqParams": { 'areaId': e.currentTarget.value }
        }).then(function (resp) {
            if (resp.success === true) {
                selectAppendOptions(districtsE, resp.districtsOptions);
            }
        });
    });

    // attachSearchByEvents
    var buttonsE = doc.getElementById('search-fiters-wrapper').children;
    var formsE = doc.getElementsByClassName('filter-form'),
        searchResultsE = doc.getElementById('search-results');

    for (var i = 0, _len = buttonsE.length; i < _len; i++) {
        searchResultsE.textContent = '';

        buttonsE[i].addEventListener('click', function (e) {
            searchResultsE.textContent = '';
            msgE.textContent = '';

            for (var j = 0, len1 = formsE.length; j < len1; j++) {
                if (e.currentTarget.getAttribute('data-id') === formsE[j].getAttribute('id')) {
                    formsE[j].classList.add('is-active');
                } else {
                    formsE[j].classList.remove('is-active');
                }
            }
        }, false);
    }

    // attachSearchButtonEvents
    var searchButtonsE = doc.getElementsByClassName('property-search-button'),
        len = searchButtonsE.length;

    while (len--) {
        searchButtonsE[len].addEventListener('click', function (e) {
            var formE = getParentElement(e.currentTarget, 'form');

            if (formE.id === 'office-by-distance-form') {
                var distanceE = formE['distance'],
                    postcodeE = formE['postcode-by-distance'];
                if (!distanceE || !postcodeE) {
                    console.log('missing form elements');
                    return;
                }

                if (isEmpty(distanceE.value) || isEmpty(postcodeE.value)) {
                    msgE.textContent = 'Required fields are left blank';
                    return;
                }
                msgE.textContent = '';
            }

            // ajax call function
            propertyFinder('Office', formE.id);
        });
    }

    //attach events to select elements
    var selectElementsE = doc.getElementsByClassName('select-area'),
        lenS = selectElementsE.length;

    while (lenS--) {
        selectElementsE[lenS].addEventListener('change', function (e) {
            var selectedId = e.currentTarget.getAttribute('id');
            var lenS1 = selectElementsE.length;
            while (lenS1--) {
                if (selectElementsE[lenS1].id !== selectedId) {
                    selectElementsE[lenS1].selectedIndex = "0";
                }
            }
        }, false);
    }
}

function searchRetail() {
    var doc = document,
        areasE = doc.getElementById('area'),
        districtsE = doc.getElementById('district'),
        msgE = doc.getElementById('msg');

    // get district by selected area
    areasE.addEventListener("change", function (e) {
        selectRemoveOptions(districtsE, 2);
        ajax({
            "URL": "/ajax/location/get-districts.php",
            "reqMethod": "POST",
            "reqType": "json",
            "reqParams": { 'areaId': e.currentTarget.value }
        }).then(function (resp) {
            if (resp.success === true) {
                selectAppendOptions(districtsE, resp.districtsOptions);
            }
        });
    });

    // attachSearchByEvents
    var buttonsE = doc.getElementById('search-fiters-wrapper').children,
        formsE = doc.getElementsByClassName('filter-form'),
        searchResultsE = doc.getElementById('search-results');

    for (var i = 0, _len = buttonsE.length; i < _len; i++) {
        buttonsE[i].addEventListener('click', function (e) {
            searchResultsE.textContent = '';
            msgE.textContent = '';

            for (var j = 0, len1 = formsE.length; j < len1; j++) {
                if (e.currentTarget.getAttribute('data-id') === formsE[j].getAttribute('id')) {
                    formsE[j].classList.add('is-active');
                } else {
                    formsE[j].classList.remove('is-active');
                }
            }
        }, false);
    }

    // attachSearchButtonEvents
    var searchButtons = doc.getElementsByClassName('property-search-button'),
        len = searchButtons.length;

    while (len--) {
        searchButtons[len].addEventListener('click', function (e) {
            var formE = getParentElement(e.currentTarget, 'form');

            if (formE.id === 'retail-by-distance-form') {
                var distanceE = formE['distance'],
                    postcodeE = formE['postcode-by-distance'];
                if (!distanceE || !postcodeE) {
                    console.log('missing form elements');
                    return;
                }

                if (isEmpty(distanceE.value) || isEmpty(postcodeE.value)) {
                    msgE.textContent = 'Required fields are left blank';
                    return;
                }
                msgE.textContent = '';
            }

            // ajax call function
            propertyFinder('Retail', formE.id);
        });
    }

    //attach events to select elements
    var selectElementsE = doc.getElementsByClassName('select-area'),
        lenS = selectElementsE.length;

    while (lenS--) {
        selectElementsE[lenS].addEventListener('change', function (e) {
            var selectedId = e.currentTarget.getAttribute('id');
            var lenS1 = selectElementsE.length;
            while (lenS1--) {
                if (selectElementsE[lenS1].id !== selectedId) {
                    selectElementsE[lenS1].selectedIndex = "0";
                }
            }
        }, false);
    }
}

function searchIndustrial() {
    var doc = document,
        areasE = doc.getElementById('area'),
        districtsE = doc.getElementById('district'),
        msgE = doc.getElementById('msg');

    // get district by selected area
    areasE.addEventListener("change", function (e) {
        selectRemoveOptions(districtsE, 2);
        ajax({
            "URL": "/ajax/location/get-districts.php",
            "reqMethod": "POST",
            "reqType": "json",
            "reqParams": { 'areaId': e.currentTarget.value }
        }).then(function (resp) {
            if (resp.success === true) {
                selectAppendOptions(districtsE, resp.districtsOptions);
            }
        });
    });

    // attachSearchByEvents
    var buttonsE = doc.getElementById('search-fiters-wrapper').children,
        formsE = doc.getElementsByClassName('filter-form'),
        searchResultsE = doc.getElementById('search-results');

    for (var i = 0, _len = buttonsE.length; i < _len; i++) {
        buttonsE[i].addEventListener('click', function (e) {
            searchResultsE.textContent = '';
            msgE.textContent = '';

            for (var j = 0, len1 = formsE.length; j < len1; j++) {
                if (e.currentTarget.getAttribute('data-id') === formsE[j].getAttribute('id')) {
                    formsE[j].classList.add('is-active');
                } else {
                    formsE[j].classList.remove('is-active');
                }
            }
        }, false);
    }

    // attachSearchButtonEvents:
    var searchButtonsE = doc.getElementsByClassName('property-search-button'),
        len = searchButtonsE.length;

    while (len--) {
        searchButtonsE[len].addEventListener('click', function (e) {
            var formE = getParentElement(e.currentTarget, 'form');

            if (formE.id === 'industrial-by-distance-form') {
                var distanceE = formE['distance'],
                    postcodeE = formE['postcode-by-distance'];
                if (!distanceE || !postcodeE) {
                    console.log('missing form elements');
                    return;
                }

                if (isEmpty(distanceE.value) || isEmpty(postcodeE.value)) {
                    msgE.textContent = 'Required fields are left blank';
                    return;
                }
                msgE.textContent = '';
            }

            // ajax call function
            propertyFinder('Industrial', formE.id);
        });
    }

    // attach events to select elements
    var selectElementsE = doc.getElementsByClassName('select-area'),
        lenS = selectElementsE.length;

    while (lenS--) {
        selectElementsE[lenS].addEventListener('change', function (e) {
            var selectedId = e.currentTarget.getAttribute('id');
            var lenS1 = selectElementsE.length;

            while (lenS1--) {
                if (selectElementsE[lenS1].id !== selectedId) {
                    selectElementsE[lenS1].selectedIndex = "0";
                }
            }
        }, false);
    }
}

function SearchByPropertyType() {
    var doc = document;
    var searchByPropTypeFrmE = doc.getElementById('search-by-property-type'),
        searchByPropTypeBtnE = doc.getElementById('search-by-property-type-btn'),
        searchResContainer = doc.getElementById('search-results'),
        oFD = searchByPropTypeFrmE ? new FormData(searchByPropTypeFrmE) : new FormData();

    searchByPropTypeBtnE.addEventListener("click", function () {
        ajax({
            "URL": "ajax/find-properties.php",
            "reqParams": oFD,
            "reqType": 'formdata'
        }).then(function (resp) {

            if (resp.success === true) {
                searchResContainer.innerHTML = resp.result;
            } else {
                searchResContainer.textContent = '';
            }
            var msgE = doc.getElementById('msg');
            if (msgE && resp.msg) {
                msgE.textContent = resp.msg;
            }
        });
    }, false);
}

var _this = window;

document.addEventListener('DOMContentLoaded', function () {
    var doc = document;

    var initFuncs = {
        "common": function () {
            var _ref = asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
                return regeneratorRuntime.wrap(function _callee$(_context) {
                    while (1) {
                        switch (_context.prev = _context.next) {
                            case 0:
                            case 'end':
                                return _context.stop();
                        }
                    }
                }, _callee, _this);
            }));

            function common() {
                return _ref.apply(this, arguments);
            }

            return common;
        }(),
        "searchOfficeInit": function () {
            var _ref2 = asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
                return regeneratorRuntime.wrap(function _callee2$(_context2) {
                    while (1) {
                        switch (_context2.prev = _context2.next) {
                            case 0:
                                searchOffice();

                            case 1:
                            case 'end':
                                return _context2.stop();
                        }
                    }
                }, _callee2, _this);
            }));

            function searchOfficeInit() {
                return _ref2.apply(this, arguments);
            }

            return searchOfficeInit;
        }(),
        "searchRetailInit": function () {
            var _ref3 = asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
                return regeneratorRuntime.wrap(function _callee3$(_context3) {
                    while (1) {
                        switch (_context3.prev = _context3.next) {
                            case 0:
                                searchRetail();

                            case 1:
                            case 'end':
                                return _context3.stop();
                        }
                    }
                }, _callee3, _this);
            }));

            function searchRetailInit() {
                return _ref3.apply(this, arguments);
            }

            return searchRetailInit;
        }(),
        "searchIndustrialInit": function () {
            var _ref4 = asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
                return regeneratorRuntime.wrap(function _callee4$(_context4) {
                    while (1) {
                        switch (_context4.prev = _context4.next) {
                            case 0:
                                searchIndustrial();

                            case 1:
                            case 'end':
                                return _context4.stop();
                        }
                    }
                }, _callee4, _this);
            }));

            function searchIndustrialInit() {
                return _ref4.apply(this, arguments);
            }

            return searchIndustrialInit;
        }(),
        "searchInvestmentInit": function () {
            var _ref5 = asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
                return regeneratorRuntime.wrap(function _callee5$(_context5) {
                    while (1) {
                        switch (_context5.prev = _context5.next) {
                            case 0:
                                propertyFinder('investment', 'investment-form');

                            case 1:
                            case 'end':
                                return _context5.stop();
                        }
                    }
                }, _callee5, _this);
            }));

            function searchInvestmentInit() {
                return _ref5.apply(this, arguments);
            }

            return searchInvestmentInit;
        }(),
        "searchLeisureInit": function () {
            var _ref6 = asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6() {
                return regeneratorRuntime.wrap(function _callee6$(_context6) {
                    while (1) {
                        switch (_context6.prev = _context6.next) {
                            case 0:
                                propertyFinder('leisure', 'leisure-form');

                            case 1:
                            case 'end':
                                return _context6.stop();
                        }
                    }
                }, _callee6, _this);
            }));

            function searchLeisureInit() {
                return _ref6.apply(this, arguments);
            }

            return searchLeisureInit;
        }(),
        "searchResidentialInit": function () {
            var _ref7 = asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee7() {
                return regeneratorRuntime.wrap(function _callee7$(_context7) {
                    while (1) {
                        switch (_context7.prev = _context7.next) {
                            case 0:
                                propertyFinder('residential', 'residential-form');

                            case 1:
                            case 'end':
                                return _context7.stop();
                        }
                    }
                }, _callee7, _this);
            }));

            function searchResidentialInit() {
                return _ref7.apply(this, arguments);
            }

            return searchResidentialInit;
        }(),
        "searchDevelopmentInit": function () {
            var _ref8 = asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee8() {
                return regeneratorRuntime.wrap(function _callee8$(_context8) {
                    while (1) {
                        switch (_context8.prev = _context8.next) {
                            case 0:
                                propertyFinder('development', 'development-form');

                            case 1:
                            case 'end':
                                return _context8.stop();
                        }
                    }
                }, _callee8, _this);
            }));

            function searchDevelopmentInit() {
                return _ref8.apply(this, arguments);
            }

            return searchDevelopmentInit;
        }(),
        "searchByPropertyTypeInit": function () {
            var _ref9 = asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee9() {
                return regeneratorRuntime.wrap(function _callee9$(_context9) {
                    while (1) {
                        switch (_context9.prev = _context9.next) {
                            case 0:
                                SearchByPropertyType();

                            case 1:
                            case 'end':
                                return _context9.stop();
                        }
                    }
                }, _callee9, _this);
            }));

            function searchByPropertyTypeInit() {
                return _ref9.apply(this, arguments);
            }

            return searchByPropertyTypeInit;
        }()
    };

    initFuncs.common.call();
    var initFn = doc.body.getAttribute('data-init');
    if (typeof initFuncs[initFn] === 'function') {
        initFuncs[initFn].call();
    }
}, false);
