<?php

	declare(strict_types = 1);
	require __DIR__ . '/vendor/autoload.php';

	use Asn\Core\Dice;
	use Asn\App\Model\AgencyPilot\PropertyFinder;


	$dc = new Dice();
	$dc->addRules([
        '*' => ['shared' => true]
    ]);

	$result = [];
	$showNumber = 10;
	$propertyType = '';

	$dcPropFinder = $dc->create(PropertyFinder::class);

	try
    {
        $result = $dcPropFinder->getRecentlyUpdated($showNumber, $propertyType);
    }
    catch(\Throwable $thr)
    {
        echo $thr->getMessage();
    }

    function returnHtmlSnippet(array $result): string
    {
        $htmlProps = '';

        foreach ($result as $key => $value){
            $htmlProps .= "<div class=\"row\">";
            $htmlProps .= "<div class=\"col-md-6\">";
            $htmlProps .= "<div><b>Area: </b>" . $value['l1_name'] . "</div>";
            $htmlProps .= "<div><b>Town: </b>" . $value['town'] . "</div>";
            if(!empty($value["l2_name"]))
            {
                $htmlProps .= "<div><b>District:</b> " . $value['l2_name'] . "</div>";
            } else {
                $htmlProps .= "<div><b>District:</b> n/a</div>";
            }
            $htmlProps .= "<div><b>Post code: </b>" . $value['post_code'] . "</div>";
            $htmlProps .= "<div><b>Unit Name: </b>" . $value['unit_name'] . "</div>";
            $htmlProps .= "<div><b>Post code: </b>" . $value['post_code'] . "</div>";
            $htmlProps .= "<div><b>Post code: </b>" . $value['post_code'] . "</div>";
            if ($value['size_dimensions'] === 4) {
                $htmlProps .= "<div><b>Size: </b>" . $value['min_size'] . " - " . $value['max_size'] . " feet</div>";
            } elseif ($value['size_dimensions'] === 5) {
                $htmlProps .= "<div><b>Size: </b>" . $value['min_size'] . " - " . $value['max_size'] . " meters</div>";
            } else {
                $htmlProps .= "<div><b>Size: </b>" . $value['min_size'] . " - " . $value['max_size'] . " acres</div>";
            }
            $htmlProps .= "<div><b>Latitude: </b>" . $value['latitude'] . "</div>";
            $htmlProps .= "<div><b>Longitude: </b>" . $value['longitude'] . "</div>";

            $lat = $value['latitude'];
            $long = $value['longitude'];

            $htmlProps .= "<div><b><a href='https://www.google.com/maps/search/?api=1&query=${lat}, ${long}'>Google maps</a></b>";

            if(isset($value['photos'])){
                $htmlProps .= "<div><b>Photos:</b></div>";
                for ( $i = 0; $i < count($value['photos']); $i++){
                    $ii = $i + 1;
                    $pics =  $value['photos'][$i];
                    $htmlProps .= "<div><a href='https://htc.agencypilot.com/store/property/${pics}'>Photo #$ii</a></div>";
                }
            }

            if(isset($value['photo_web'])){
                $photoWeb = $value['photo_web'];
                $htmlProps .= "<div><b>Photo Web:</b><br><a href='https://htc.agencypilot.com/store/property/${photoWeb}'>Photo Web</a></div>";
            }

            if(isset($value['brochures'])){
                $htmlProps .= "<div><b>Brochures:</b></div>";
                for ( $i = 0; $i < count($value['brochures']); $i++){
                    $pdf = $value['brochures'][$i];
                    $htmlProps .= "<div><a href='https://htc.agencypilot.com/store/documents/other/${pdf}'>Download PDF</a></div>";
                }
            }

            $htmlProps .= "</div>";
            $htmlProps .= "</div>";
            $htmlProps .= "<hr>";
        }

        return $htmlProps;
    }

    echo returnHtmlSnippet($result);

