<?php

    namespace Asn\Core\Http;

    class Request
    {

        protected $server;
        protected $queryParam;
        protected $post;
        protected $cookie;
        protected $inputStream;

        public function __construct()
        {
            $this->server = $_SERVER;
            $this->queryParam = $_GET;
            $this->post = $_POST;
            $this->files = $_FILES;
            $this->cookie = $_COOKIE;
            $this->inputStream = file_get_contents('php://input');
        }

        /**
         * Returns GET parameters
         * If no $key is passed returns entire $_GET array
         *
         * @param string $key
         * @return mixed
         */
        public function getQueryParams(string $key = null)
        {
            if ($key) {
                return $this->queryParam[$key] ?? null;
            }
            return $this->queryParam;
        }

        /**
         * Returns POST parameters
         * If no $key is passed returns entire $_POST array
         *
         * @param string $key
         * @return mixed
         */
        public function getPostParams(string $key = null)
        {
            if ($key) {
                return $this->post[$key] ?? null;
            }
            return $this->post;
        }

        /**
         * Returns posted files
         * If no $key is passed returns entire $_FILES array
         *
         * @param string $key
         * @return mixed
         */
        public function getFiles(string $key = null)
        {
            if ($key) {
                return $this->files[$key] ?? null;
            }
            return $this->files;
        }

        /**
         * Returns cookie
         * If no $key is passed returns entire $_COOKIE array
         *
         * @param string $key
         * @return mixed
         */
        public function getCookie(string $key = null)
        {
            if ($key) {
                return $this->cookie[$key] ?? null;
            }
            return $this->cookie;
        }

        /**
         * Returns server variable
         *
         * @param string $key
         * @return string|int|null
         */
        public function getServerVar(string $key)
        {
            return $this->server[$key] ?? null;
        }

        /**
         * Returns stream that allows to read raw POST data
         *
         * @return string
         */
        public function getInputStream()
        {
            return $this->inputStream;
        }

    }