<?php

    namespace Asn\App\Controllers\Search;

    use Asn\Core\Page;
    use Asn\Core\Renderer;
    use Asn\Core\Http\Request;
    use Asn\App\Model\Dimensions;
    use Asn\App\Model\Location;

    class SearchByPropType extends Page
    {

        protected $template = 'search-by-prop-type';
        protected $pageName = 'Search By Property Type';
        protected $location;

        public function __construct(Request $request, Renderer $renderer, Location $location)
        {
            parent::__construct($request, $renderer);
            $this->location = $location;
        }

        /**
         * @throws \Exception
         */
        protected function setTemplateData()
        {
            $this->renderer->addData('page-title', $this->pageName)
                    ->addData('init', 'searchByPropertyTypeInit')
                    ->addData('areas', $this->location->getAreas());
        }

    }
