<?php

    namespace Asn\App\Model\AgencyPilot;

    use Asn\Core\Database;

    class FetchLocation
    {

        protected $db;
        private $url;

        public function __construct(Database $db)
        {
            $apiUrl = @include __DIR__ . '/../../../config/agencypilot.settings.php';
            $this->db = $db;
            $this->url = $apiUrl['url'].'?w='.$apiUrl['queryParams']['location'].'&pw='.$apiUrl['password'];
        }

        /**
         * Insert data in local database
         *
         * @return bool
         * @throws \Throwable
         */
        public function insertData(): bool
        {
            try
            {
                $fd = new FetchData();
                $jsonArr = $fd->fetch($this->url);
            }
            catch (\Throwable $thr)
            {
                throw $thr;
            }

            $res = $jsonArr['S_LOCATIONSL2'];

            if (!isset($res) || count($res) === 0) {
                return false;
            }
            $sqlRows = [];

            for ($i = 0; $i < count($res); $i++) {
                $sqlRows[] = [
                    'l1_name' => $res[$i]['L1_NAME'],
                    'l1_no' => $res[$i]['L1_NO'],
                    'l2_name' => $res[$i]['L2_NAME'],
                    'l2_no' => $res[$i]['L2_NO'],
                    'northings' => $res[$i]['Northings'],
                    'eastings' => $res[$i]['Eastings']
                ];
            }

            if (count($sqlRows) === 0) {
                throw new \Exception('Array is empty!');
            }

            $this->db->beginTransaction();
            try {
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 0");
                $this->db->exec("DELETE FROM districts_l2");
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 1");

                $sql = /** @lang text */
                        'INSERT INTO districts_l2';
                $this->db->insertMulti($sql, $sqlRows);

                $this->db->commit();
            } catch (\Throwable $thr) {
                $this->db->rollBack();
                throw $thr;
            }

            return true;
        }

    }
