<?php

    namespace Asn\App\Model;

    use Asn\Core\Database;

    class Location
    {

        protected $db;

        public function __construct(Database $db)
        {
            $this->db = $db;
        }

        /**
         * Return all areas, sorted by name
         *
         * @return array
         * @throws \Exception
         */
        public function getAreas(): array
        {
            $query = $this->db->exec("SELECT
                                             `name`, `no`
                                            FROM
                                              `area_l1`
                                            ORDER BY
                                              `name` ASC");

            $rows = $query->fetchAll();

            return $rows;
        }

        /**
         * Returns districts in given area
         *
         * @param int $l1_no Area id
         * @return array
         */
        public function getDistricts(int $l1_no): array
        {
            $result = $this->db->exec("SELECT
                                            l2_no,
                                            l2_name
                                        FROM
                                            districts_l2
                                        WHERE
                                            l1_no = :l1_no
                                        ORDER BY l2_name ASC", [
                [":l1_no", $l1_no]
            ]);
            $rows = $result->fetchAll();
            return $rows;
        }
    }
