<?php

    namespace Asn\Core;

    class Partials
    {

        /**
         * Returns string containing html partial
         *
         * @param string $section app section
         * @param string $filename the file containing the partial template
         * @param array $tplData template data
         * @return string
         * @throws \Exception
         */
        public function get(string $section, string $filename, array $tplData = []): string
        {
            $section = ($section === '/') ? '' : '/' . $section;
            $path = __DIR__ . '/../templates' . $section . '/partials/' . $filename;

            if (!file_exists($path)) {
                throw new \Exception("$path not found");
            } else {
                ob_start();
                include($path);
                $str = ob_get_contents();
                ob_end_clean();
                return $str;
            }
        }

    }