// Global variables
var xhrPool = []; // AJAX requests pool

/**
 * Makes an ajax call
 *
 * @param {object} settings
 * @param {string} settings.URL
 * @param {?boolean} settings.addToPool
 * @param {?boolean} settings.abortPending
 * @param {string} settings.reqMethod [POST|GET]
 * @param {string} settings.reqType [formdata|json]
 * @param {object} settings.reqParams [null]
 * @param {string} settings.respType [json|text]
 * @param {object} settings.callback 
 */

function ajax(settings) {

    if (settings.abortPending === true) {
        for (let i = 0, len = xhrPool.length; i < len; i++) {
            if (xhrPool[i]) {
                xhrPool[i].abort();
            }
        }
        xhrPool.length = 0;
    }

    return new Promise((resolve, reject) => {
        let xhr = new XMLHttpRequest(),
            strURL = settings.URL,
            reqMethod = settings.reqMethod || 'POST',
            reqType = settings.reqType || 'formdata',
            respType = settings.respType || 'json',
            reqParams = typeof settings.reqParams === 'object' ? settings.reqParams : null;

        if (reqParams) {
            if (reqMethod === 'GET') {
                let qs = '',
                    rqKeys = Object.keys(reqParams);
                for (let i = 0, iLen = rqKeys.length; i < iLen; i++) {
                    qs += encodeURIComponent(rqKeys[i]) + "=" + encodeURIComponent(reqParams[rqKeys[i]]) + "&";
                }

                if (qs) {
                    strURL += "?" + qs.slice(0, -1);
                }

            } else if (reqType === 'json') {
                reqParams = JSON.stringify(reqParams);
            }
        }

        xhr.onreadystatechange = function () {
            if (xhr.readyState === 1 && settings.addToPool) {
                xhrPool.push(xhr);
            }

            if (xhr.readyState === 4) {
                if (settings.addToPool) {
                    let hxrIndex = xhrPool.indexOf(xhr);
                    if (hxrIndex > -1) {
                        xhrPool.splice(hxrIndex, 1);
                    }
                }

                if (xhr.status === 200) {
                    let resp = xhr.response;
                    if (respType === 'json') {
                        // Needed for IE only as it return sring instead of JSON
                        resp = xhr.responseType === 'json' ? xhr.response : JSON.parse(xhr.responseText);
                        if (typeof resp !== 'object' || resp === null) {
                            reject(resp);
                        }
                    }
                    resolve(resp);
                } else {
                    reject(xhr.status); 
                }
            }
        };

        xhr.open(reqMethod, strURL, true);

        if (reqType === 'json') {
            xhr.setRequestHeader("Content-Type", "application/json");
        }
        xhr.responseType = respType;
        xhr.send(reqParams);
    });
}

export {ajax}