<?php

    namespace Asn\App\Model\AgencyPilot;

    use Asn\Core\Database;

    class FetchFloors
    {

        protected $db;
        private $url;

        public function __construct(Database $db)
        {
            $apiUrl = @include __DIR__ . '/../../../config/agencypilot.settings.php';
            $this->db = $db;
            $this->url = $apiUrl['url'].'?w='.$apiUrl['queryParams']['floors'].'&pw='.$apiUrl['password'];
        }

        /**
         * Insert data in local database
         *
         * @return bool
         * @throws \Throwable
         */
        public function insertData(): bool
        {
            try
            {
                $fd = new FetchData();
                $jsonArr = $fd->fetch($this->url);
            }
            catch (\Throwable $thr)
            {
                throw $thr;
            }

            $res = $jsonArr['S_FLOOR'];

            if (!isset($res) || count($res) === 0) {
                return false;
            }

            $sqlRows = [];

            for ($i = 0; $i < count($res); $i++) {
                $sqlRows[] = [
                    'property_key' => $res[$i]['Property_Key'],
                    'floor_name' => $res[$i]['Floor_Name'],
                    'floor_description' => $res[$i]['Floor_Description'],
                    'floor_min_size' => $res[$i]['Floor_MinSize'],
                    'floor_max_size' => $res[$i]['Floor_MaxSize'],
                    'floor_dimension' => $res[$i]['Floor_Dimension'],
                    'floor_2_min_size' => $res[$i]['Floor_2nd_MinSize'],
                    'floor_2_max_size' => $res[$i]['Floor_2nd_MaxSize'],
                    'floor_2_dimension' => $res[$i]['Floor_2nd_Dimension'],
                    'floor_status' => $res[$i]['Floor_Status'],
                    'floor_rate' => $res[$i]['Floor_Rate'],
                    'floor_erv' => $res[$i]['Floor_ERV']
                ];
            }

            if (count($sqlRows) === 0) {
                throw new \Exception('Array is empty!');
            }

            $this->db->beginTransaction();
            try {
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 0");
                $this->db->exec("DELETE FROM floors");
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 1");

                $sql = /** @lang text */
                        'INSERT INTO floors';
                $this->db->insertMulti($sql, $sqlRows);

                $this->db->commit();
            } catch (\Throwable $thr) {
                $this->db->rollBack();
                throw $thr;
            }

            return true;
        }

    }
