<?php

    namespace Asn\App\Model\AgencyPilot;

    use Asn\Core\Database;

    class FetchUnitTypeGroups
    {
        protected $db;
        private $url;

        public function __construct(Database $db)
        {
            $apiUrl = @include __DIR__ . '/../../../config/agencypilot.settings.php';
            $this->db = $db;
            $this->url = $apiUrl['url'].'?w='.$apiUrl['queryParams']['unitTypeGroups'].'&pw='.$apiUrl['password'];
        }

        /**
         * Insert data in local database
         *
         * @return bool
         * @throws \Throwable
         */
        public function insertData(): bool
        {
            try
            {
                $fd = new FetchData();
                $jsonArr = $fd->fetch($this->url);
            }
            catch (\Throwable $thr)
            {
                throw $thr;
            }

            $res = $jsonArr['S_UNIT_GROUPS'];
            $sqlRows = [];

            if (!isset($res) || count($res) === 0) {
                return false;
            }

            for ($i = 0; $i < count($res); $i++) {
                $sqlRows[] = ['name' => $res[$i]['NAME'], 'no' => $res[$i]['NO'], 'unit_no_links' => $res[$i]['UnitNoLinks']];
            }

            if (count($sqlRows) === 0) {
                throw new \Exception('Array is empty!');
            }

            $this->db->beginTransaction();
            try {
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 0");
                $this->db->exec("DELETE FROM unit_type_groups");
                $this->db->exec("SET FOREIGN_KEY_CHECKS = 1");

                $sql = /** @lang text */
                        'INSERT INTO unit_type_groups';
                $this->db->insertMulti($sql, $sqlRows);

                $this->db->commit();
            } catch (\Throwable $thr) {
                $this->db->rollBack();
                throw $thr;
            }

            return true;
        }

    }
