<?php

    namespace Asn\Core;

    use Asn\Core\Http\Request;

    class Section
    {

        protected $request;
        protected $appBasedir;
        protected $sections;
        protected $section;
        protected $sectionData = [];

        /**
         *
         * @param Request $request HTTP request
         */
        public function __construct(Request $request)
        {
            $this->request = $request;

            $appSettings = require __DIR__ . '/../config/app.config.php';

            $this->appBasedir = $appSettings['app_basedir'];
            $this->sections = $appSettings['sections'];

            $requestUri = $this->request->getServerVar('REQUEST_URI');

            $uriPath = ($this->appBasedir === '/') ? $requestUri : substr($requestUri, strlen($this->appBasedir));
            $uriSection = explode('/', $uriPath)[1] ?? '';

            $this->section = (isset($this->sections[$uriSection])) ? $uriSection : '/';
        }

        /**
         * Returns app base directory (with leading slash)
         * 
         * @return string
         */
        public function getAppBase(): string
        {
            return ($this->appBasedir === '/') ? '' : '/' . $this->appBasedir;
        }

        /**
         * Returns section directory (with leading slash)
         *
         * @return string
         */
        public function getSectionBase(): string
        {
            return ($this->section === '/') ? '' : '/' . $this->section;
        }

        /**
         * Return section's default settings
         *
         * @return array
         */
        public function getDefalutSettings(): array
        {
            return $this->sections[$this->section] ?? [];
        }

        /**
         * Returns section bootstrap data
         *
         * @return array
         */
        public function getSectionData(): array
        {
            return $this->sectionData;
        }

        /**
         * Adds section bootstrap data
         *
         * @param string $k
         * @param int|float|string|array|bool|null $data
         */
        protected function addSectionData(string $k, $data)
        {
            if (is_scalar($data) || is_array($data) || is_null($data)) {
                $this->sectionData[$k] = $data;
            }
        }

    }