import {ajax} from './ajax-promise';

export function SearchByPropertyType() {
    const doc = document;
    let searchByPropTypeFrmE = doc.getElementById('search-by-property-type'),
        searchByPropTypeBtnE = doc.getElementById('search-by-property-type-btn'),
        searchResContainer = doc.getElementById('search-results'),
        oFD = searchByPropTypeFrmE ? new FormData(searchByPropTypeFrmE) : new FormData();

    searchByPropTypeBtnE.addEventListener("click", () => {
        ajax({
            "URL": "ajax/find-properties.php",
            "reqParams": oFD,
            "reqType": 'formdata'
        }).then((resp) => {

            if (resp.success === true) {
                searchResContainer.innerHTML = resp.result;
            } else {
                searchResContainer.textContent = '';
            }
            const msgE = doc.getElementById('msg');
            if (msgE && resp.msg) {
                msgE.textContent = resp.msg;
            }
        });
    }, false);
}