async function sidebarMenu() {
    const menuSidebar = document.getElementById('menu-sidebar');

    if (menuSidebar) {
        // Set current menu link
        const anchorElems = menuSidebar.getElementsByTagName('a'),
            winHref = window.location.href;

        for (let i = 0, iLen = anchorElems.length; i < iLen; i++) {
            if (anchorElems[i].href === winHref) {
                anchorElems[i].classList.add('menu-current');

                let p = anchorElems[i];
                while (p.parentNode) {
                    p = p.parentNode;
                    if (p.nodeType === 1 && p.classList.contains('menu-sub')) {
                        p.classList.add('expanded');
                    }
                }
                break;
            }
        }

        // Add slide toggle events for sum-menus
        const toggleElems = menuSidebar.getElementsByClassName('menu-sub-toggle');

        for (let i = 0, iLen = toggleElems.length; i < iLen; i++) {
            toggleElems[i].addEventListener('click', () => {
                const sub = toggleElems[i].parentNode.getElementsByClassName('menu-sub')[0];

                if (sub) {
                    sub.style.maxHeight = sub.scrollHeight + 'px';

                    // Function to be called on trasitionend event (slide up/down)
                    function transEnd() {
                        sub.removeAttribute('style');
                        sub.removeEventListener('transitionend', transEnd, false);

                        // Dispatch scroll event if customScrollbar is used on the menu
                        if (menuSidebar.classList.contains('scrollable')) {
                            menuSidebar.dispatchEvent(new Event('scroll'));
                        }
                    }

                    // Use RAF to start transitions
                    if (sub.classList.contains('expanded')) {
                        sub.style.maxHeight = sub.scrollHeight + 'px';
                        sub.addEventListener('transitionend', transEnd, false);

                        requestAnimationFrame(function () {
                            sub.classList.remove('expanded');
                            sub.style.removeProperty('max-height');
                        });
                    } else {
                        sub.addEventListener('transitionend', transEnd, false);

                        requestAnimationFrame(function () {
                            sub.classList.add('expanded');
                        });
                    }
                }
            }, false);
        }
    }
}

export {sidebarMenu};