<?php

    declare(strict_types = 1);
    header("Content-Type: application/json");

    require __DIR__ . '/../vendor/autoload.php';

    use Asn\Core\Dice;
    use Asn\Core\Http\Request;
    use Asn\App\Model\AgencyPilot\PropertyFinder;
    use Asn\App\Library\Pagination;
    use Asn\Core\Partials;

    $dc = new Dice();
    $dc->addRules([
        '*' => ['shared' => true]
    ]);

    // Creating new Requset instance and get vars from $_POST
    $request = new Request();
    $post = $request->getPostParams();




    $filters = [];

    // Variables and logic for pagination
    $page = (isset($post['page'])) && is_numeric($post['page']) ? (int) $post['page'] : 0;
    $perPage = isset($post['perPage']) && is_numeric($post['perPage']) ? (int) $post['perPage'] : 0;
    $filterId = isset($post['filterId']) ? trim($post['filterId']) : '';

    if ($page <= 0) {
        $page = 1;
    }
    if ($perPage <= 0) {
        $perPage = 5;
    }
    $start = ($page - 1) * $perPage;

    // Property type
    if(isset($post['property-type'])) {
        $filters['propertyType'] = isset($post['property-type']) ? trim($post['property-type']) : null;
//        if (!$filters['propertyType']) {
//           unset($filters['propertyType']);
//            exit(json_encode(['success' => false, 'msg' => 'Invalid property type!']));
//        }
    } elseif (isset($post['propertyType'])) {
        $filters['propertyType'] = isset($post['propertyType']) ? trim($post['propertyType']) : null;
        if (!$filters['propertyType']) {
            exit(json_encode(['success' => false, 'msg' => 'Invalid property type!']));
        }
    }

    // District (location link id)
    if (isset($post['district']) && is_numeric($post['district'])) {
        $filters['locationLink'] = (int) $post['district'];
    }
    // Area
    if(isset($post['area']) && is_numeric($post['area'])) {
        $filters['area'] = (int) $post['area'];
    }

    // Town
    if (isset($post['town']) && !empty($post['town'])) {
        $filters['town'] = trim($post['town']);
    }

    // Post code address
    if (isset($post['postcode']) && !empty($post['postcode'])) {
        $filters['postCodeAddress'] = trim($post['postcode']);
    }

    if (isset($post['postcode-by-distance']) && !empty($post['postcode-by-distance'])) {
        $filters['postCode'] = trim($post['postcode-by-distance']);
    }

    // Distance in miles
    if (isset($post['distance']) && is_numeric($post['distance'])) {
        $filters['distance'] = (int) $post['distance'];
    }

    if (isset($post['freehold'])) {
        $filters['freehold'] = 1;
    }

    if (isset($post['leasehold'])) {
        $filters['leasehold'] = 1;
    }

    if (isset($post['long-leasehold'])) {
        $filters['long-leasehold'] = 10;
    }

    // area square feets
    if (isset($post['area-sq-ft']) && !empty($post['area-sq-ft'])) {
        $areaSq = explode("-", $post['area-sq-ft']);

        if (count($areaSq) === 3) {
            if (is_numeric($areaSq[0])) {
                $filters['size-dimension'] = (int) $areaSq[0];
            }

            if (is_numeric($areaSq[1])) {
                $filters['size-min'] = (int) $areaSq[1];
            }

            if (is_numeric($areaSq[2])) {
                $filters['size-max'] = (int) $areaSq[2];
            }
        }
    }

    // area square meters
    if (isset($post['area-sq-m']) && !empty($post['area-sq-m'])) {
        $areaSq = explode("-", $post['area-sq-m']);

        if (count($areaSq) === 3) {
            if (is_numeric($areaSq[0])) {
                $filters['size-dimension'] = (int) $areaSq[0];
            }

            if (is_numeric($areaSq[1])) {
                $filters['size-min'] = (int) $areaSq[1];
            }

            if (is_numeric($areaSq[2])) {
                $filters['size-max'] = (int) $areaSq[2];
            }
        }
    }

    // area acres
    if (isset($post['area-acres']) && !empty($post['area-acres'])) {
        $areaSq = explode("-", $post['area-acres']);

        if (count($areaSq) === 3) {
            if (is_numeric($areaSq[0])) {
                $filters['size-dimension'] = (int) $areaSq[0];
            }

            if (is_numeric($areaSq[1])) {
                $filters['size-min'] = (int) $areaSq[1];
            }

            if (is_numeric($areaSq[2])) {
                $filters['size-max'] = (int) $areaSq[2];
            }
        }
    }

    //exit(json_encode(['success' => false, 'msg' => $filters]));

    try {
        $dcPropertyFinder = $dc->create(PropertyFinder::class);
        $arr = $dcPropertyFinder->find($filters, $start, $perPage);

        // results
        $result = $arr['arrKeys'];
        $totalCount = $arr['totalCount'];

        // pagination
        $paginator = new Pagination();
        $paginationHtml = $paginator->paginationAjax($totalCount, 'propertyFinder', ["'" . $filters['propertyType'] . "'", "'" . $filterId . "'"], $page, $perPage);

        // partial
        $partial = new Partials();
        $propertiesHtml = $partial->get('/', 'search-results.tpl.php', ['result' => $result, 'totalCount' => $totalCount, 'paginationHtml' => $paginationHtml]);

        exit(json_encode(['success' => true, 'msg' => '', 'result' => $propertiesHtml ]));
    } catch (\Throwable $thr) {
        exit(json_encode(['success' => false, 'msg' => $thr->getMessage()]));
    }

