<?php

    namespace Asn\App\Model\Admin;

    use Asn\Core\Database;
    use Asn\Core\Encryption;
    use Asn\Core\Http\Session;
    use Asn\Core\Http\Request;
    use \Asn\Core\Auth;

    class Admin extends Auth
    {

        public function __construct(Database $db, Encryption $enc, Session $session, Request $request)
        {
            parent::__construct($db, $enc, $session, $request);
            $this->user_role = 'admin';
        }

        /**
         *
         * @return boolean|int
         */
        public function isAdmin()
        {
            return ($this->isAuth()) ?: false;
        }

        /**
         * @param int $userId
         * @param int $status
         * @return array
         * @throws \Exception
         */
        public function setUserStatus(int $userId, int $status): array
        {
            if ($status < 0) {
                return ['success' => false, 'msg' => 'Invalid status'];
            }

            $this->db->exec("UPDATE users
				SET status = :status
				WHERE user_id = :user_id
				LIMIT 1", [
                [':status', $status],
                [':user_id', $userId]
            ]);

            return ['success' => true, 'msg' => 'Updated'];
        }

        /**
         * @param int $userId
         * @param int $role
         * @return array
         * @throws \Exception
         */
        public function setUserRole(int $userId, int $role): array
        {
            if ($role <= 0) {
                return ['success' => false, 'msg' => 'Invalid user role'];
            }

            $this->db->exec("UPDATE users
				SET role = :role
				WHERE user_id = :user_id
				LIMIT 1", [
                [':role', $role],
                [':user_id', $userId]
            ]);

            $this->db->exec("DELETE FROM users_auth
				WHERE user_id = :user_id
				LIMIT 1", [
                [':user_id', $userId]
            ]);

            return ['success' => true, 'msg' => 'Updated'];
        }

    }
