<?php

    namespace Asn\App\Model\AgencyPilot;

    class FetchData
    {

        /**
         * Fetch data from remote json API url
         *
         * @param string $url
         *
         * @return array
         * @throws \Exception
         */
        public function fetch(string $url): array
        {

            $result = '';

            // Curl init
            $ch = curl_init();

            // Set req options
            $options = array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_TIMEOUT => 20
            );
            curl_setopt_array($ch, $options);

            // Getting results if no errors && http code is '200'
            if (curl_error($ch) === '' || (curl_getinfo($ch, CURLINFO_HTTP_CODE) === 200)) {
                $result = curl_exec($ch);
            }

            // Close curl resource
            curl_close($ch);

            $result = str_replace(["\t", "\v"], '', $result);
            $resultArr = json_decode($result, true);

            if (is_null($resultArr) || empty($resultArr)) {
                throw new \Exception('No data found!');
            }

            return $resultArr;
        }

    }
