import {ajax} from '../ajax-promise';
import * as utils from '../utils';
import {propertyFinder} from '../property-finder';

export function searchIndustrial()
{
    const doc = document,
        areasE = doc.getElementById('area'),
        districtsE = doc.getElementById('district'),
        msgE = doc.getElementById('msg');

    // get district by selected area
    areasE.addEventListener("change", (e) => {
        utils.selectRemoveOptions(districtsE, 2);
        ajax({
            "URL": "/ajax/location/get-districts.php",
            "reqMethod": "POST",
            "reqType": "json",
            "reqParams": {'areaId': e.currentTarget.value}
        }).then((resp) =>
        {
            if (resp.success === true)
            {
                utils.selectAppendOptions(districtsE, resp.districtsOptions);
            }
        });
    });

    // attachSearchByEvents
    let buttonsE = doc.getElementById('search-fiters-wrapper').children,
        formsE = doc.getElementsByClassName('filter-form'),
        searchResultsE = doc.getElementById('search-results');

    for (let i = 0, len = buttonsE.length; i < len; i++)
    {
        buttonsE[i].addEventListener('click', (e) =>
        {
            searchResultsE.textContent = '';
            msgE.textContent = '';

            for (let j = 0, len1 = formsE.length; j < len1; j++)
            {
                if (e.currentTarget.getAttribute('data-id') === formsE[j].getAttribute('id'))
                {
                    formsE[j].classList.add('is-active');
                } else
                {
                    formsE[j].classList.remove('is-active');
                }
            }
        }, false);
    }

    // attachSearchButtonEvents:
    let searchButtonsE = doc.getElementsByClassName('property-search-button'),
        len = searchButtonsE.length;

    while (len--) {
        searchButtonsE[len].addEventListener('click', (e) =>
        {
            let formE = utils.getParentElement(e.currentTarget, 'form');

            if (formE.id === 'industrial-by-distance-form') {
                const distanceE = formE['distance'],
                    postcodeE = formE['postcode-by-distance'];
                if (!distanceE || !postcodeE) {
                    console.log('missing form elements');
                    return;
                }

                if (utils.isEmpty(distanceE.value) || utils.isEmpty(postcodeE.value)) {
                    msgE.textContent = 'Required fields are left blank';
                    return;
                }
                msgE.textContent = '';
            }

            // ajax call function
            propertyFinder('Industrial', formE.id);
        });
    }

    // attach events to select elements
    let selectElementsE = doc.getElementsByClassName('select-area'),
        lenS = selectElementsE.length;

    while (lenS--) {
        selectElementsE[lenS].addEventListener('change', (e) =>
        {
            let selectedId = e.currentTarget.getAttribute('id');
            let lenS1 = selectElementsE.length;

            while (lenS1--)
            {
                if (selectElementsE[lenS1].id !== selectedId)
                {
                    selectElementsE[lenS1].selectedIndex = "0";
                }
            }
        }, false);
    }

}


