import {searchOffice} from './modules/search/office';
import {searchRetail} from './modules/search/retail';
import {searchIndustrial} from './modules/search/industrial';
import {propertyFinder} from './modules/property-finder';
import {SearchByPropertyType} from './modules/search-by-property-type';

document.addEventListener('DOMContentLoaded', () => {
    const doc = document;

    const initFuncs = {
        "common": async () => {
        },
        "searchOfficeInit": async () => {
            searchOffice();
        },
        "searchRetailInit": async () => {
            searchRetail();
        },
        "searchIndustrialInit": async () => {
            searchIndustrial();
        },
        "searchInvestmentInit": async () => {
            propertyFinder('investment', 'investment-form');
        },
        "searchLeisureInit": async () => {
            propertyFinder('leisure', 'leisure-form');
        },
        "searchResidentialInit": async () => {
            propertyFinder('residential', 'residential-form');
        },
        "searchDevelopmentInit": async () => {
            propertyFinder('development', 'development-form');
        },
        "searchByPropertyTypeInit": async () => {
            SearchByPropertyType();
        }
    };

    initFuncs.common.call();
    const initFn = doc.body.getAttribute('data-init');
    if (typeof initFuncs[initFn] === 'function') {
        initFuncs[initFn].call();
    }
}, false);